/*
 * QrfeRfeReaderFactory.cpp
 *
 *  Created on: 14.05.2009
 *      Author: stefan.detter
 */

#include "../inc/QrfeReaderFactory.h"

#include "../inc/reader/QrfeRfePurReader.h"

#include <QrfeSleeper>
#include <QrfeProtocolHandlerRFE>

#include "../inc/reader/app/QrfeRfePurHidKeyboardReader.h"

uint  QrfeReaderFactory::_traceLevel = 6;

QrfeReaderFactory::QrfeReaderFactory()
	: QrfeTraceModule("QrfeReaderFactory", _traceLevel)
{

}

QrfeReaderFactory::~QrfeReaderFactory()
{
}

QrfeRfeReader* QrfeReaderFactory::getRfeReader(QIODevice* dev, QrfeGlobal::DeviceType deviceType, QObject* parent)
{
	strc("QrfeReaderFactory", _traceLevel + 1, "Creating a rfe protocol handler");
	QrfeProtocolHandlerRFE* ph = new QrfeProtocolHandlerRFE(dev, deviceType, parent);

	ulong type = 0;
	QrfeGlobal::Result res;
	for(int i = 0; i < 5; i++){
		res = ph->getReaderType(type);
		if(res == QrfeGlobal::RES_OK)
			break;
	}
	if(res != QrfeGlobal::RES_OK){
		swarning("QrfeReaderFactory", "Could not get reader type");
		delete ph;
		return 0;
	}

	strc("QrfeReaderFactory", _traceLevel + 1, "Reader Type = " + QString("%1").arg(type, 8, 16, QChar('0')));

    if(QrfeGlobal::isPUR(type))
	{
        QrfeGlobal::ReaderModule module = QrfeGlobal::getReaderModule(type);
        if( module == QrfeGlobal::VERSION_RFE_PUR_RM1 ||
            module == QrfeGlobal::VERSION_RFE_PUR_RM2)
        {
            switch( QrfeGlobal::getApplicationId(type) )
            {
            case QrfeGlobal::PUR_APP_HID_KEYBOARD:
                strc("QrfeReaderFactory", _traceLevel + 1, "Creating a rfe HID Keyboard reader object");
                return new QrfeRfePurHidKeyboardReader(ph, parent);

            default:
                strc("QrfeReaderFactory", _traceLevel + 1, "Creating a rfe PUR object");
                return new QrfeRfePurReader(ph, parent);
            }
        }
        else
        {
            delete ph;
            return 0;
        }
	}
	else
	{
		delete ph;
		return 0;
	}

}

